<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SecurityCommandCenter;

class GoogleCloudSecuritycenterV2CloudControl extends \Google\Model
{
  /**
   * @var string
   */
  public $cloudControlName;
  /**
   * @var string
   */
  public $policyType;
  /**
   * @var string
   */
  public $type;
  /**
   * @var int
   */
  public $version;

  /**
   * @param string
   */
  public function setCloudControlName($cloudControlName)
  {
    $this->cloudControlName = $cloudControlName;
  }
  /**
   * @return string
   */
  public function getCloudControlName()
  {
    return $this->cloudControlName;
  }
  /**
   * @param string
   */
  public function setPolicyType($policyType)
  {
    $this->policyType = $policyType;
  }
  /**
   * @return string
   */
  public function getPolicyType()
  {
    return $this->policyType;
  }
  /**
   * @param string
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
  /**
   * @param int
   */
  public function setVersion($version)
  {
    $this->version = $version;
  }
  /**
   * @return int
   */
  public function getVersion()
  {
    return $this->version;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudSecuritycenterV2CloudControl::class, 'Google_Service_SecurityCommandCenter_GoogleCloudSecuritycenterV2CloudControl');
