<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DiscoveryEngine;

class GoogleCloudDiscoveryengineV1ProvisionProjectRequest extends \Google\Model
{
  /**
   * @var bool
   */
  public $acceptDataUseTerms;
  /**
   * @var string
   */
  public $dataUseTermsVersion;
  protected $saasParamsType = GoogleCloudDiscoveryengineV1ProvisionProjectRequestSaasParams::class;
  protected $saasParamsDataType = '';

  /**
   * @param bool
   */
  public function setAcceptDataUseTerms($acceptDataUseTerms)
  {
    $this->acceptDataUseTerms = $acceptDataUseTerms;
  }
  /**
   * @return bool
   */
  public function getAcceptDataUseTerms()
  {
    return $this->acceptDataUseTerms;
  }
  /**
   * @param string
   */
  public function setDataUseTermsVersion($dataUseTermsVersion)
  {
    $this->dataUseTermsVersion = $dataUseTermsVersion;
  }
  /**
   * @return string
   */
  public function getDataUseTermsVersion()
  {
    return $this->dataUseTermsVersion;
  }
  /**
   * @param GoogleCloudDiscoveryengineV1ProvisionProjectRequestSaasParams
   */
  public function setSaasParams(GoogleCloudDiscoveryengineV1ProvisionProjectRequestSaasParams $saasParams)
  {
    $this->saasParams = $saasParams;
  }
  /**
   * @return GoogleCloudDiscoveryengineV1ProvisionProjectRequestSaasParams
   */
  public function getSaasParams()
  {
    return $this->saasParams;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDiscoveryengineV1ProvisionProjectRequest::class, 'Google_Service_DiscoveryEngine_GoogleCloudDiscoveryengineV1ProvisionProjectRequest');
