<?php
// This file was auto-generated from sdk-root/src/data/bedrock-agentcore/2024-02-28/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2024-02-28', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'bedrock-agentcore', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceFullName' => 'Amazon Bedrock AgentCore Data Plane Fronting Layer', 'serviceId' => 'Bedrock AgentCore', 'signatureVersion' => 'v4', 'signingName' => 'bedrock-agentcore', 'uid' => 'bedrock-agentcore-2024-02-28', ], 'operations' => [ 'CreateEvent' => [ 'name' => 'CreateEvent', 'http' => [ 'method' => 'POST', 'requestUri' => '/memories/{memoryId}/events', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateEventInput', ], 'output' => [ 'shape' => 'CreateEventOutput', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledException', ], [ 'shape' => 'ServiceException', ], ], 'idempotent' => true, ], 'DeleteEvent' => [ 'name' => 'DeleteEvent', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/memories/{memoryId}/actor/{actorId}/sessions/{sessionId}/events/{eventId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteEventInput', ], 'output' => [ 'shape' => 'DeleteEventOutput', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledException', ], [ 'shape' => 'ServiceException', ], ], ], 'DeleteMemoryRecord' => [ 'name' => 'DeleteMemoryRecord', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/memories/{memoryId}/memoryRecords/{memoryRecordId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteMemoryRecordInput', ], 'output' => [ 'shape' => 'DeleteMemoryRecordOutput', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledException', ], [ 'shape' => 'ServiceException', ], ], ], 'GetBrowserSession' => [ 'name' => 'GetBrowserSession', 'http' => [ 'method' => 'GET', 'requestUri' => '/browsers/{browserIdentifier}/sessions/get', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetBrowserSessionRequest', ], 'output' => [ 'shape' => 'GetBrowserSessionResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetCodeInterpreterSession' => [ 'name' => 'GetCodeInterpreterSession', 'http' => [ 'method' => 'GET', 'requestUri' => '/code-interpreters/{codeInterpreterIdentifier}/sessions/get', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetCodeInterpreterSessionRequest', ], 'output' => [ 'shape' => 'GetCodeInterpreterSessionResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetEvent' => [ 'name' => 'GetEvent', 'http' => [ 'method' => 'GET', 'requestUri' => '/memories/{memoryId}/actor/{actorId}/sessions/{sessionId}/events/{eventId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetEventInput', ], 'output' => [ 'shape' => 'GetEventOutput', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledException', ], [ 'shape' => 'ServiceException', ], ], ], 'GetMemoryRecord' => [ 'name' => 'GetMemoryRecord', 'http' => [ 'method' => 'GET', 'requestUri' => '/memories/{memoryId}/memoryRecord/{memoryRecordId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetMemoryRecordInput', ], 'output' => [ 'shape' => 'GetMemoryRecordOutput', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledException', ], [ 'shape' => 'ServiceException', ], ], ], 'GetResourceApiKey' => [ 'name' => 'GetResourceApiKey', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/api-key', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetResourceApiKeyRequest', ], 'output' => [ 'shape' => 'GetResourceApiKeyResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetResourceOauth2Token' => [ 'name' => 'GetResourceOauth2Token', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/oauth2/token', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetResourceOauth2TokenRequest', ], 'output' => [ 'shape' => 'GetResourceOauth2TokenResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetWorkloadAccessToken' => [ 'name' => 'GetWorkloadAccessToken', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/GetWorkloadAccessToken', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetWorkloadAccessTokenRequest', ], 'output' => [ 'shape' => 'GetWorkloadAccessTokenResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetWorkloadAccessTokenForJWT' => [ 'name' => 'GetWorkloadAccessTokenForJWT', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/GetWorkloadAccessTokenForJWT', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetWorkloadAccessTokenForJWTRequest', ], 'output' => [ 'shape' => 'GetWorkloadAccessTokenForJWTResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetWorkloadAccessTokenForUserId' => [ 'name' => 'GetWorkloadAccessTokenForUserId', 'http' => [ 'method' => 'POST', 'requestUri' => '/identities/GetWorkloadAccessTokenForUserId', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetWorkloadAccessTokenForUserIdRequest', ], 'output' => [ 'shape' => 'GetWorkloadAccessTokenForUserIdResponse', ], 'errors' => [ [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'InvokeAgentRuntime' => [ 'name' => 'InvokeAgentRuntime', 'http' => [ 'method' => 'POST', 'requestUri' => '/runtimes/{agentRuntimeArn}/invocations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'InvokeAgentRuntimeRequest', ], 'output' => [ 'shape' => 'InvokeAgentRuntimeResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'RuntimeClientError', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'InvokeCodeInterpreter' => [ 'name' => 'InvokeCodeInterpreter', 'http' => [ 'method' => 'POST', 'requestUri' => '/code-interpreters/{codeInterpreterIdentifier}/tools/invoke', 'responseCode' => 200, ], 'input' => [ 'shape' => 'InvokeCodeInterpreterRequest', ], 'output' => [ 'shape' => 'InvokeCodeInterpreterResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListActors' => [ 'name' => 'ListActors', 'http' => [ 'method' => 'POST', 'requestUri' => '/memories/{memoryId}/actors', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListActorsInput', ], 'output' => [ 'shape' => 'ListActorsOutput', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledException', ], [ 'shape' => 'ServiceException', ], ], ], 'ListBrowserSessions' => [ 'name' => 'ListBrowserSessions', 'http' => [ 'method' => 'POST', 'requestUri' => '/browsers/{browserIdentifier}/sessions/list', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListBrowserSessionsRequest', ], 'output' => [ 'shape' => 'ListBrowserSessionsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListCodeInterpreterSessions' => [ 'name' => 'ListCodeInterpreterSessions', 'http' => [ 'method' => 'POST', 'requestUri' => '/code-interpreters/{codeInterpreterIdentifier}/sessions/list', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListCodeInterpreterSessionsRequest', ], 'output' => [ 'shape' => 'ListCodeInterpreterSessionsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListEvents' => [ 'name' => 'ListEvents', 'http' => [ 'method' => 'POST', 'requestUri' => '/memories/{memoryId}/actor/{actorId}/sessions/{sessionId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListEventsInput', ], 'output' => [ 'shape' => 'ListEventsOutput', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledException', ], [ 'shape' => 'ServiceException', ], ], ], 'ListMemoryRecords' => [ 'name' => 'ListMemoryRecords', 'http' => [ 'method' => 'POST', 'requestUri' => '/memories/{memoryId}/memoryRecords', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListMemoryRecordsInput', ], 'output' => [ 'shape' => 'ListMemoryRecordsOutput', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledException', ], [ 'shape' => 'ServiceException', ], ], ], 'ListSessions' => [ 'name' => 'ListSessions', 'http' => [ 'method' => 'POST', 'requestUri' => '/memories/{memoryId}/actor/{actorId}/sessions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSessionsInput', ], 'output' => [ 'shape' => 'ListSessionsOutput', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledException', ], [ 'shape' => 'ServiceException', ], ], ], 'RetrieveMemoryRecords' => [ 'name' => 'RetrieveMemoryRecords', 'http' => [ 'method' => 'POST', 'requestUri' => '/memories/{memoryId}/retrieve', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RetrieveMemoryRecordsInput', ], 'output' => [ 'shape' => 'RetrieveMemoryRecordsOutput', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InvalidInputException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledException', ], [ 'shape' => 'ServiceException', ], ], ], 'StartBrowserSession' => [ 'name' => 'StartBrowserSession', 'http' => [ 'method' => 'PUT', 'requestUri' => '/browsers/{browserIdentifier}/sessions/start', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StartBrowserSessionRequest', ], 'output' => [ 'shape' => 'StartBrowserSessionResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'StartCodeInterpreterSession' => [ 'name' => 'StartCodeInterpreterSession', 'http' => [ 'method' => 'PUT', 'requestUri' => '/code-interpreters/{codeInterpreterIdentifier}/sessions/start', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StartCodeInterpreterSessionRequest', ], 'output' => [ 'shape' => 'StartCodeInterpreterSessionResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'StopBrowserSession' => [ 'name' => 'StopBrowserSession', 'http' => [ 'method' => 'PUT', 'requestUri' => '/browsers/{browserIdentifier}/sessions/stop', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StopBrowserSessionRequest', ], 'output' => [ 'shape' => 'StopBrowserSessionResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'StopCodeInterpreterSession' => [ 'name' => 'StopCodeInterpreterSession', 'http' => [ 'method' => 'PUT', 'requestUri' => '/code-interpreters/{codeInterpreterIdentifier}/sessions/stop', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StopCodeInterpreterSessionRequest', ], 'output' => [ 'shape' => 'StopCodeInterpreterSessionResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'UpdateBrowserStream' => [ 'name' => 'UpdateBrowserStream', 'http' => [ 'method' => 'PUT', 'requestUri' => '/browsers/{browserIdentifier}/sessions/streams/update', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateBrowserStreamRequest', ], 'output' => [ 'shape' => 'UpdateBrowserStreamResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AccessTokenType' => [ 'type' => 'string', 'max' => 131072, 'min' => 1, 'sensitive' => true, ], 'ActorId' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '[a-zA-Z0-9][a-zA-Z0-9-_/]*', ], 'ActorSummary' => [ 'type' => 'structure', 'required' => [ 'actorId', ], 'members' => [ 'actorId' => [ 'shape' => 'ActorId', ], ], ], 'ActorSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ActorSummary', ], ], 'ApiKeyType' => [ 'type' => 'string', 'max' => 65536, 'min' => 1, 'sensitive' => true, ], 'AutomationStream' => [ 'type' => 'structure', 'required' => [ 'streamEndpoint', 'streamStatus', ], 'members' => [ 'streamEndpoint' => [ 'shape' => 'BrowserStreamEndpoint', ], 'streamStatus' => [ 'shape' => 'AutomationStreamStatus', ], ], ], 'AutomationStreamStatus' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'AutomationStreamUpdate' => [ 'type' => 'structure', 'members' => [ 'streamStatus' => [ 'shape' => 'AutomationStreamStatus', ], ], ], 'Blob' => [ 'type' => 'blob', ], 'Body' => [ 'type' => 'blob', 'max' => 100000000, 'min' => 0, 'sensitive' => true, ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'Branch' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'rootEventId' => [ 'shape' => 'EventId', ], 'name' => [ 'shape' => 'BranchName', ], ], ], 'BranchFilter' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'BranchName', ], 'includeParentBranches' => [ 'shape' => 'Boolean', ], ], ], 'BranchName' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '[a-zA-Z0-9][a-zA-Z0-9-_]*', ], 'BrowserSessionId' => [ 'type' => 'string', 'pattern' => '[0-9a-zA-Z]{1,40}', ], 'BrowserSessionStatus' => [ 'type' => 'string', 'enum' => [ 'READY', 'TERMINATED', ], ], 'BrowserSessionStream' => [ 'type' => 'structure', 'required' => [ 'automationStream', ], 'members' => [ 'automationStream' => [ 'shape' => 'AutomationStream', ], 'liveViewStream' => [ 'shape' => 'LiveViewStream', ], ], ], 'BrowserSessionSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'BrowserSessionSummary', ], ], 'BrowserSessionSummary' => [ 'type' => 'structure', 'required' => [ 'browserIdentifier', 'sessionId', 'status', 'createdAt', ], 'members' => [ 'browserIdentifier' => [ 'shape' => 'String', ], 'sessionId' => [ 'shape' => 'BrowserSessionId', ], 'name' => [ 'shape' => 'Name', ], 'status' => [ 'shape' => 'BrowserSessionStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'BrowserSessionTimeout' => [ 'type' => 'integer', 'box' => true, 'max' => 28800, 'min' => 1, ], 'BrowserStreamEndpoint' => [ 'type' => 'string', 'max' => 512, 'min' => 10, ], 'ClientToken' => [ 'type' => 'string', 'max' => 256, 'min' => 33, 'pattern' => '[a-zA-Z0-9](-*[a-zA-Z0-9]){0,256}', ], 'CodeInterpreterResult' => [ 'type' => 'structure', 'required' => [ 'content', ], 'members' => [ 'content' => [ 'shape' => 'ContentBlockList', ], 'structuredContent' => [ 'shape' => 'ToolResultStructuredContent', ], 'isError' => [ 'shape' => 'Boolean', ], ], 'event' => true, ], 'CodeInterpreterSessionId' => [ 'type' => 'string', 'pattern' => '[0-9a-zA-Z]{1,40}', ], 'CodeInterpreterSessionStatus' => [ 'type' => 'string', 'enum' => [ 'READY', 'TERMINATED', ], ], 'CodeInterpreterSessionSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'CodeInterpreterSessionSummary', ], ], 'CodeInterpreterSessionSummary' => [ 'type' => 'structure', 'required' => [ 'codeInterpreterIdentifier', 'sessionId', 'status', 'createdAt', ], 'members' => [ 'codeInterpreterIdentifier' => [ 'shape' => 'String', ], 'sessionId' => [ 'shape' => 'CodeInterpreterSessionId', ], 'name' => [ 'shape' => 'Name', ], 'status' => [ 'shape' => 'CodeInterpreterSessionStatus', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'CodeInterpreterSessionTimeout' => [ 'type' => 'integer', 'box' => true, 'max' => 28800, 'min' => 1, ], 'CodeInterpreterStreamOutput' => [ 'type' => 'structure', 'members' => [ 'result' => [ 'shape' => 'CodeInterpreterResult', ], 'accessDeniedException' => [ 'shape' => 'AccessDeniedException', ], 'conflictException' => [ 'shape' => 'ConflictException', ], 'internalServerException' => [ 'shape' => 'InternalServerException', ], 'resourceNotFoundException' => [ 'shape' => 'ResourceNotFoundException', ], 'serviceQuotaExceededException' => [ 'shape' => 'ServiceQuotaExceededException', ], 'throttlingException' => [ 'shape' => 'ThrottlingException', ], 'validationException' => [ 'shape' => 'ValidationException', ], ], 'eventstream' => true, ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'Content' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'ContentTextString', ], ], 'union' => true, ], 'ContentBlock' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'ContentBlockType', ], 'text' => [ 'shape' => 'String', ], 'data' => [ 'shape' => 'Blob', ], 'mimeType' => [ 'shape' => 'String', ], 'uri' => [ 'shape' => 'String', ], 'name' => [ 'shape' => 'String', ], 'description' => [ 'shape' => 'String', ], 'size' => [ 'shape' => 'Long', ], 'resource' => [ 'shape' => 'ResourceContent', ], ], ], 'ContentBlockList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ContentBlock', ], ], 'ContentBlockType' => [ 'type' => 'string', 'enum' => [ 'text', 'image', 'resource', 'resource_link', ], ], 'ContentTextString' => [ 'type' => 'string', 'max' => 9000, 'min' => 1, 'sensitive' => true, ], 'Conversational' => [ 'type' => 'structure', 'required' => [ 'content', 'role', ], 'members' => [ 'content' => [ 'shape' => 'Content', ], 'role' => [ 'shape' => 'Role', ], ], ], 'CreateEventInput' => [ 'type' => 'structure', 'required' => [ 'memoryId', 'actorId', 'eventTimestamp', 'payload', ], 'members' => [ 'memoryId' => [ 'shape' => 'MemoryId', 'location' => 'uri', 'locationName' => 'memoryId', ], 'actorId' => [ 'shape' => 'ActorId', ], 'sessionId' => [ 'shape' => 'SessionId', ], 'eventTimestamp' => [ 'shape' => 'Timestamp', ], 'payload' => [ 'shape' => 'PayloadTypeList', ], 'branch' => [ 'shape' => 'Branch', ], 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], ], ], 'CreateEventOutput' => [ 'type' => 'structure', 'required' => [ 'event', ], 'members' => [ 'event' => [ 'shape' => 'Event', ], ], ], 'CredentialProviderName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9\\-_]+', ], 'CustomRequestKeyType' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[a-zA-Z0-9\\-_\\.]+', ], 'CustomRequestParametersType' => [ 'type' => 'map', 'key' => [ 'shape' => 'CustomRequestKeyType', ], 'value' => [ 'shape' => 'CustomRequestValueType', ], ], 'CustomRequestValueType' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'sensitive' => true, ], 'DateTimestamp' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'DeleteEventInput' => [ 'type' => 'structure', 'required' => [ 'memoryId', 'sessionId', 'eventId', 'actorId', ], 'members' => [ 'memoryId' => [ 'shape' => 'MemoryId', 'location' => 'uri', 'locationName' => 'memoryId', ], 'sessionId' => [ 'shape' => 'SessionId', 'location' => 'uri', 'locationName' => 'sessionId', ], 'eventId' => [ 'shape' => 'EventId', 'location' => 'uri', 'locationName' => 'eventId', ], 'actorId' => [ 'shape' => 'ActorId', 'location' => 'uri', 'locationName' => 'actorId', ], ], ], 'DeleteEventOutput' => [ 'type' => 'structure', 'required' => [ 'eventId', ], 'members' => [ 'eventId' => [ 'shape' => 'EventId', ], ], ], 'DeleteMemoryRecordInput' => [ 'type' => 'structure', 'required' => [ 'memoryId', 'memoryRecordId', ], 'members' => [ 'memoryId' => [ 'shape' => 'MemoryId', 'location' => 'uri', 'locationName' => 'memoryId', ], 'memoryRecordId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'memoryRecordId', ], ], ], 'DeleteMemoryRecordOutput' => [ 'type' => 'structure', 'required' => [ 'memoryRecordId', ], 'members' => [ 'memoryRecordId' => [ 'shape' => 'String', ], ], ], 'Document' => [ 'type' => 'structure', 'members' => [], 'document' => true, ], 'Double' => [ 'type' => 'double', 'box' => true, ], 'Event' => [ 'type' => 'structure', 'required' => [ 'memoryId', 'actorId', 'sessionId', 'eventId', 'eventTimestamp', 'payload', ], 'members' => [ 'memoryId' => [ 'shape' => 'MemoryId', ], 'actorId' => [ 'shape' => 'ActorId', ], 'sessionId' => [ 'shape' => 'SessionId', ], 'eventId' => [ 'shape' => 'EventId', ], 'eventTimestamp' => [ 'shape' => 'Timestamp', ], 'payload' => [ 'shape' => 'PayloadTypeList', ], 'branch' => [ 'shape' => 'Branch', ], ], ], 'EventId' => [ 'type' => 'string', 'pattern' => '[0-9]+#[a-fA-F0-9]+', ], 'EventList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Event', ], ], 'FilterInput' => [ 'type' => 'structure', 'members' => [ 'branch' => [ 'shape' => 'BranchFilter', ], ], ], 'GetBrowserSessionRequest' => [ 'type' => 'structure', 'required' => [ 'browserIdentifier', 'sessionId', ], 'members' => [ 'browserIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'browserIdentifier', ], 'sessionId' => [ 'shape' => 'BrowserSessionId', 'location' => 'querystring', 'locationName' => 'sessionId', ], ], ], 'GetBrowserSessionResponse' => [ 'type' => 'structure', 'required' => [ 'browserIdentifier', 'sessionId', 'createdAt', ], 'members' => [ 'browserIdentifier' => [ 'shape' => 'String', ], 'sessionId' => [ 'shape' => 'BrowserSessionId', ], 'name' => [ 'shape' => 'Name', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'viewPort' => [ 'shape' => 'ViewPort', ], 'sessionTimeoutSeconds' => [ 'shape' => 'BrowserSessionTimeout', ], 'status' => [ 'shape' => 'BrowserSessionStatus', ], 'streams' => [ 'shape' => 'BrowserSessionStream', ], 'sessionReplayArtifact' => [ 'shape' => 'String', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'GetCodeInterpreterSessionRequest' => [ 'type' => 'structure', 'required' => [ 'codeInterpreterIdentifier', 'sessionId', ], 'members' => [ 'codeInterpreterIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'codeInterpreterIdentifier', ], 'sessionId' => [ 'shape' => 'CodeInterpreterSessionId', 'location' => 'querystring', 'locationName' => 'sessionId', ], ], ], 'GetCodeInterpreterSessionResponse' => [ 'type' => 'structure', 'required' => [ 'codeInterpreterIdentifier', 'sessionId', 'createdAt', ], 'members' => [ 'codeInterpreterIdentifier' => [ 'shape' => 'String', ], 'sessionId' => [ 'shape' => 'CodeInterpreterSessionId', ], 'name' => [ 'shape' => 'Name', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'sessionTimeoutSeconds' => [ 'shape' => 'CodeInterpreterSessionTimeout', ], 'status' => [ 'shape' => 'CodeInterpreterSessionStatus', ], ], ], 'GetEventInput' => [ 'type' => 'structure', 'required' => [ 'memoryId', 'sessionId', 'actorId', 'eventId', ], 'members' => [ 'memoryId' => [ 'shape' => 'MemoryId', 'location' => 'uri', 'locationName' => 'memoryId', ], 'sessionId' => [ 'shape' => 'SessionId', 'location' => 'uri', 'locationName' => 'sessionId', ], 'actorId' => [ 'shape' => 'ActorId', 'location' => 'uri', 'locationName' => 'actorId', ], 'eventId' => [ 'shape' => 'EventId', 'location' => 'uri', 'locationName' => 'eventId', ], ], ], 'GetEventOutput' => [ 'type' => 'structure', 'required' => [ 'event', ], 'members' => [ 'event' => [ 'shape' => 'Event', ], ], ], 'GetMemoryRecordInput' => [ 'type' => 'structure', 'required' => [ 'memoryId', 'memoryRecordId', ], 'members' => [ 'memoryId' => [ 'shape' => 'MemoryId', 'location' => 'uri', 'locationName' => 'memoryId', ], 'memoryRecordId' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'memoryRecordId', ], ], ], 'GetMemoryRecordOutput' => [ 'type' => 'structure', 'required' => [ 'memoryRecord', ], 'members' => [ 'memoryRecord' => [ 'shape' => 'MemoryRecord', ], ], ], 'GetResourceApiKeyRequest' => [ 'type' => 'structure', 'required' => [ 'workloadIdentityToken', 'resourceCredentialProviderName', ], 'members' => [ 'workloadIdentityToken' => [ 'shape' => 'WorkloadIdentityTokenType', ], 'resourceCredentialProviderName' => [ 'shape' => 'CredentialProviderName', ], ], ], 'GetResourceApiKeyResponse' => [ 'type' => 'structure', 'required' => [ 'apiKey', ], 'members' => [ 'apiKey' => [ 'shape' => 'ApiKeyType', ], ], ], 'GetResourceOauth2TokenRequest' => [ 'type' => 'structure', 'required' => [ 'workloadIdentityToken', 'resourceCredentialProviderName', 'scopes', 'oauth2Flow', ], 'members' => [ 'workloadIdentityToken' => [ 'shape' => 'WorkloadIdentityTokenType', ], 'resourceCredentialProviderName' => [ 'shape' => 'CredentialProviderName', ], 'scopes' => [ 'shape' => 'ScopesListType', ], 'oauth2Flow' => [ 'shape' => 'Oauth2FlowType', ], 'resourceOauth2ReturnUrl' => [ 'shape' => 'ResourceOauth2ReturnUrlType', ], 'forceAuthentication' => [ 'shape' => 'Boolean', ], 'customParameters' => [ 'shape' => 'CustomRequestParametersType', ], ], ], 'GetResourceOauth2TokenResponse' => [ 'type' => 'structure', 'members' => [ 'authorizationUrl' => [ 'shape' => 'String', ], 'accessToken' => [ 'shape' => 'AccessTokenType', ], ], ], 'GetWorkloadAccessTokenForJWTRequest' => [ 'type' => 'structure', 'required' => [ 'workloadName', 'userToken', ], 'members' => [ 'workloadName' => [ 'shape' => 'WorkloadIdentityNameType', ], 'userToken' => [ 'shape' => 'UserTokenType', ], ], ], 'GetWorkloadAccessTokenForJWTResponse' => [ 'type' => 'structure', 'required' => [ 'workloadAccessToken', ], 'members' => [ 'workloadAccessToken' => [ 'shape' => 'WorkloadIdentityTokenType', ], ], ], 'GetWorkloadAccessTokenForUserIdRequest' => [ 'type' => 'structure', 'required' => [ 'workloadName', 'userId', ], 'members' => [ 'workloadName' => [ 'shape' => 'WorkloadIdentityNameType', ], 'userId' => [ 'shape' => 'UserIdType', ], ], ], 'GetWorkloadAccessTokenForUserIdResponse' => [ 'type' => 'structure', 'required' => [ 'workloadAccessToken', ], 'members' => [ 'workloadAccessToken' => [ 'shape' => 'WorkloadIdentityTokenType', ], ], ], 'GetWorkloadAccessTokenRequest' => [ 'type' => 'structure', 'required' => [ 'workloadName', ], 'members' => [ 'workloadName' => [ 'shape' => 'WorkloadIdentityNameType', ], ], ], 'GetWorkloadAccessTokenResponse' => [ 'type' => 'structure', 'required' => [ 'workloadAccessToken', ], 'members' => [ 'workloadAccessToken' => [ 'shape' => 'WorkloadIdentityTokenType', ], ], ], 'HttpResponseCode' => [ 'type' => 'integer', 'box' => true, ], 'InputContentBlock' => [ 'type' => 'structure', 'required' => [ 'path', ], 'members' => [ 'path' => [ 'shape' => 'MaxLenString', ], 'text' => [ 'shape' => 'MaxLenString', ], 'blob' => [ 'shape' => 'Body', ], ], ], 'InputContentBlockList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InputContentBlock', ], ], 'Integer' => [ 'type' => 'integer', 'box' => true, ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'InvalidInputException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'InvokeAgentRuntimeRequest' => [ 'type' => 'structure', 'required' => [ 'agentRuntimeArn', 'payload', ], 'members' => [ 'contentType' => [ 'shape' => 'MimeType', 'location' => 'header', 'locationName' => 'Content-Type', ], 'accept' => [ 'shape' => 'MimeType', 'location' => 'header', 'locationName' => 'Accept', ], 'mcpSessionId' => [ 'shape' => 'StringType', 'location' => 'header', 'locationName' => 'Mcp-Session-Id', ], 'runtimeSessionId' => [ 'shape' => 'SessionType', 'idempotencyToken' => true, 'location' => 'header', 'locationName' => 'X-Amzn-Bedrock-AgentCore-Runtime-Session-Id', ], 'mcpProtocolVersion' => [ 'shape' => 'StringType', 'location' => 'header', 'locationName' => 'Mcp-Protocol-Version', ], 'runtimeUserId' => [ 'shape' => 'StringType', 'location' => 'header', 'locationName' => 'X-Amzn-Bedrock-AgentCore-Runtime-User-Id', ], 'traceId' => [ 'shape' => 'InvokeAgentRuntimeRequestTraceIdString', 'location' => 'header', 'locationName' => 'X-Amzn-Trace-Id', ], 'traceParent' => [ 'shape' => 'InvokeAgentRuntimeRequestTraceParentString', 'location' => 'header', 'locationName' => 'traceparent', ], 'traceState' => [ 'shape' => 'InvokeAgentRuntimeRequestTraceStateString', 'location' => 'header', 'locationName' => 'tracestate', ], 'baggage' => [ 'shape' => 'InvokeAgentRuntimeRequestBaggageString', 'location' => 'header', 'locationName' => 'baggage', ], 'agentRuntimeArn' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'agentRuntimeArn', ], 'qualifier' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'qualifier', ], 'payload' => [ 'shape' => 'Body', ], ], 'payload' => 'payload', ], 'InvokeAgentRuntimeRequestBaggageString' => [ 'type' => 'string', 'max' => 8192, 'min' => 0, ], 'InvokeAgentRuntimeRequestTraceIdString' => [ 'type' => 'string', 'max' => 128, 'min' => 0, ], 'InvokeAgentRuntimeRequestTraceParentString' => [ 'type' => 'string', 'max' => 128, 'min' => 0, ], 'InvokeAgentRuntimeRequestTraceStateString' => [ 'type' => 'string', 'max' => 512, 'min' => 0, ], 'InvokeAgentRuntimeResponse' => [ 'type' => 'structure', 'required' => [ 'contentType', ], 'members' => [ 'runtimeSessionId' => [ 'shape' => 'SessionId', 'location' => 'header', 'locationName' => 'X-Amzn-Bedrock-AgentCore-Runtime-Session-Id', ], 'mcpSessionId' => [ 'shape' => 'SessionId', 'location' => 'header', 'locationName' => 'Mcp-Session-Id', ], 'mcpProtocolVersion' => [ 'shape' => 'String', 'location' => 'header', 'locationName' => 'Mcp-Protocol-Version', ], 'traceId' => [ 'shape' => 'String', 'location' => 'header', 'locationName' => 'X-Amzn-Trace-Id', ], 'traceParent' => [ 'shape' => 'String', 'location' => 'header', 'locationName' => 'traceparent', ], 'traceState' => [ 'shape' => 'String', 'location' => 'header', 'locationName' => 'tracestate', ], 'baggage' => [ 'shape' => 'String', 'location' => 'header', 'locationName' => 'baggage', ], 'contentType' => [ 'shape' => 'String', 'location' => 'header', 'locationName' => 'Content-Type', ], 'response' => [ 'shape' => 'ResponseStream', ], 'statusCode' => [ 'shape' => 'HttpResponseCode', 'location' => 'statusCode', ], ], 'payload' => 'response', ], 'InvokeCodeInterpreterRequest' => [ 'type' => 'structure', 'required' => [ 'codeInterpreterIdentifier', 'name', ], 'members' => [ 'codeInterpreterIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'codeInterpreterIdentifier', ], 'sessionId' => [ 'shape' => 'CodeInterpreterSessionId', 'location' => 'header', 'locationName' => 'x-amzn-code-interpreter-session-id', ], 'name' => [ 'shape' => 'ToolName', ], 'arguments' => [ 'shape' => 'ToolArguments', ], ], ], 'InvokeCodeInterpreterResponse' => [ 'type' => 'structure', 'required' => [ 'stream', ], 'members' => [ 'sessionId' => [ 'shape' => 'CodeInterpreterSessionId', 'location' => 'header', 'locationName' => 'x-amzn-code-interpreter-session-id', ], 'stream' => [ 'shape' => 'CodeInterpreterStreamOutput', ], ], 'payload' => 'stream', ], 'ListActorsInput' => [ 'type' => 'structure', 'required' => [ 'memoryId', ], 'members' => [ 'memoryId' => [ 'shape' => 'MemoryId', 'location' => 'uri', 'locationName' => 'memoryId', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListActorsOutput' => [ 'type' => 'structure', 'required' => [ 'actorSummaries', ], 'members' => [ 'actorSummaries' => [ 'shape' => 'ActorSummaryList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListBrowserSessionsRequest' => [ 'type' => 'structure', 'required' => [ 'browserIdentifier', ], 'members' => [ 'browserIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'browserIdentifier', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], 'status' => [ 'shape' => 'BrowserSessionStatus', ], ], ], 'ListBrowserSessionsResponse' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'BrowserSessionSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListCodeInterpreterSessionsRequest' => [ 'type' => 'structure', 'required' => [ 'codeInterpreterIdentifier', ], 'members' => [ 'codeInterpreterIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'codeInterpreterIdentifier', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], 'status' => [ 'shape' => 'CodeInterpreterSessionStatus', ], ], ], 'ListCodeInterpreterSessionsResponse' => [ 'type' => 'structure', 'required' => [ 'items', ], 'members' => [ 'items' => [ 'shape' => 'CodeInterpreterSessionSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListEventsInput' => [ 'type' => 'structure', 'required' => [ 'memoryId', 'sessionId', 'actorId', ], 'members' => [ 'memoryId' => [ 'shape' => 'MemoryId', 'location' => 'uri', 'locationName' => 'memoryId', ], 'sessionId' => [ 'shape' => 'SessionId', 'location' => 'uri', 'locationName' => 'sessionId', ], 'actorId' => [ 'shape' => 'ActorId', 'location' => 'uri', 'locationName' => 'actorId', ], 'includePayloads' => [ 'shape' => 'Boolean', ], 'filter' => [ 'shape' => 'FilterInput', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListEventsOutput' => [ 'type' => 'structure', 'required' => [ 'events', ], 'members' => [ 'events' => [ 'shape' => 'EventList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListMemoryRecordsInput' => [ 'type' => 'structure', 'required' => [ 'memoryId', 'namespace', ], 'members' => [ 'memoryId' => [ 'shape' => 'MemoryId', 'location' => 'uri', 'locationName' => 'memoryId', ], 'namespace' => [ 'shape' => 'Namespace', ], 'memoryStrategyId' => [ 'shape' => 'MemoryStrategyId', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListMemoryRecordsOutput' => [ 'type' => 'structure', 'required' => [ 'memoryRecordSummaries', ], 'members' => [ 'memoryRecordSummaries' => [ 'shape' => 'MemoryRecordSummaryList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListSessionsInput' => [ 'type' => 'structure', 'required' => [ 'memoryId', 'actorId', ], 'members' => [ 'memoryId' => [ 'shape' => 'MemoryId', 'location' => 'uri', 'locationName' => 'memoryId', ], 'actorId' => [ 'shape' => 'ActorId', 'location' => 'uri', 'locationName' => 'actorId', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListSessionsOutput' => [ 'type' => 'structure', 'required' => [ 'sessionSummaries', ], 'members' => [ 'sessionSummaries' => [ 'shape' => 'SessionSummaryList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'LiveViewStream' => [ 'type' => 'structure', 'members' => [ 'streamEndpoint' => [ 'shape' => 'BrowserStreamEndpoint', ], ], ], 'Long' => [ 'type' => 'long', 'box' => true, ], 'MaxLenString' => [ 'type' => 'string', 'max' => 100000000, 'min' => 0, ], 'MaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'MemoryContent' => [ 'type' => 'structure', 'members' => [ 'text' => [ 'shape' => 'SensitiveString', ], ], 'union' => true, ], 'MemoryId' => [ 'type' => 'string', 'min' => 12, 'pattern' => '[a-zA-Z][a-zA-Z0-9-_]{0,99}-[a-zA-Z0-9]{10}', ], 'MemoryRecord' => [ 'type' => 'structure', 'required' => [ 'memoryRecordId', 'content', 'memoryStrategyId', 'namespaces', 'createdAt', ], 'members' => [ 'memoryRecordId' => [ 'shape' => 'MemoryRecordId', ], 'content' => [ 'shape' => 'MemoryContent', ], 'memoryStrategyId' => [ 'shape' => 'MemoryStrategyId', ], 'namespaces' => [ 'shape' => 'NamespacesList', ], 'createdAt' => [ 'shape' => 'Timestamp', ], ], ], 'MemoryRecordId' => [ 'type' => 'string', 'max' => 40, 'min' => 40, 'pattern' => 'mem-[a-zA-Z0-9-]*', ], 'MemoryRecordSummary' => [ 'type' => 'structure', 'required' => [ 'memoryRecordId', 'content', 'memoryStrategyId', 'namespaces', 'createdAt', ], 'members' => [ 'memoryRecordId' => [ 'shape' => 'MemoryRecordId', ], 'content' => [ 'shape' => 'MemoryContent', ], 'memoryStrategyId' => [ 'shape' => 'MemoryStrategyId', ], 'namespaces' => [ 'shape' => 'NamespacesList', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'score' => [ 'shape' => 'Double', ], ], ], 'MemoryRecordSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MemoryRecordSummary', ], ], 'MemoryStrategyId' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '[a-zA-Z0-9][a-zA-Z0-9-_]*', ], 'MimeType' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'Name' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'Namespace' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '[a-zA-Z0-9/*][a-zA-Z0-9-_/*]*', ], 'NamespacesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Namespace', ], 'min' => 1, ], 'NextToken' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '\\S*', ], 'NonBlankString' => [ 'type' => 'string', 'pattern' => '[\\s\\S]+', ], 'Oauth2FlowType' => [ 'type' => 'string', 'enum' => [ 'USER_FEDERATION', 'M2M', ], ], 'PaginationToken' => [ 'type' => 'string', ], 'PayloadType' => [ 'type' => 'structure', 'members' => [ 'conversational' => [ 'shape' => 'Conversational', ], 'blob' => [ 'shape' => 'Document', ], ], 'union' => true, ], 'PayloadTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PayloadType', ], 'max' => 100, 'min' => 0, ], 'ProgrammingLanguage' => [ 'type' => 'string', 'enum' => [ 'python', 'javascript', 'typescript', ], ], 'ResourceContent' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'ResourceContentType', ], 'uri' => [ 'shape' => 'String', ], 'mimeType' => [ 'shape' => 'String', ], 'text' => [ 'shape' => 'String', ], 'blob' => [ 'shape' => 'Blob', ], ], ], 'ResourceContentType' => [ 'type' => 'string', 'enum' => [ 'text', 'blob', ], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'ResourceOauth2ReturnUrlType' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '\\w+:(\\/?\\/?)[^\\s]+', ], 'ResponseStream' => [ 'type' => 'blob', 'sensitive' => true, 'streaming' => true, ], 'RetrieveMemoryRecordsInput' => [ 'type' => 'structure', 'required' => [ 'memoryId', 'namespace', 'searchCriteria', ], 'members' => [ 'memoryId' => [ 'shape' => 'MemoryId', 'location' => 'uri', 'locationName' => 'memoryId', ], 'namespace' => [ 'shape' => 'Namespace', ], 'searchCriteria' => [ 'shape' => 'SearchCriteria', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], 'maxResults' => [ 'shape' => 'MaxResults', ], ], ], 'RetrieveMemoryRecordsOutput' => [ 'type' => 'structure', 'required' => [ 'memoryRecordSummaries', ], 'members' => [ 'memoryRecordSummaries' => [ 'shape' => 'MemoryRecordSummaryList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'Role' => [ 'type' => 'string', 'enum' => [ 'ASSISTANT', 'USER', 'TOOL', 'OTHER', ], ], 'RuntimeClientError' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 424, 'senderFault' => true, ], 'exception' => true, ], 'ScopeType' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'ScopesListType' => [ 'type' => 'list', 'member' => [ 'shape' => 'ScopeType', ], ], 'SearchCriteria' => [ 'type' => 'structure', 'required' => [ 'searchQuery', ], 'members' => [ 'searchQuery' => [ 'shape' => 'SearchCriteriaSearchQueryString', ], 'memoryStrategyId' => [ 'shape' => 'MemoryStrategyId', ], 'topK' => [ 'shape' => 'SearchCriteriaTopKInteger', ], ], ], 'SearchCriteriaSearchQueryString' => [ 'type' => 'string', 'max' => 10000, 'min' => 1, 'sensitive' => true, ], 'SearchCriteriaTopKInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'SensitiveString' => [ 'type' => 'string', 'sensitive' => true, ], 'ServiceException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'SessionId' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '[a-zA-Z0-9][a-zA-Z0-9-_]*', ], 'SessionSummary' => [ 'type' => 'structure', 'required' => [ 'sessionId', 'actorId', 'createdAt', ], 'members' => [ 'sessionId' => [ 'shape' => 'SessionId', ], 'actorId' => [ 'shape' => 'ActorId', ], 'createdAt' => [ 'shape' => 'Timestamp', ], ], ], 'SessionSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SessionSummary', ], ], 'SessionType' => [ 'type' => 'string', 'max' => 256, 'min' => 33, ], 'StartBrowserSessionRequest' => [ 'type' => 'structure', 'required' => [ 'browserIdentifier', ], 'members' => [ 'browserIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'browserIdentifier', ], 'name' => [ 'shape' => 'Name', ], 'sessionTimeoutSeconds' => [ 'shape' => 'BrowserSessionTimeout', ], 'viewPort' => [ 'shape' => 'ViewPort', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'StartBrowserSessionResponse' => [ 'type' => 'structure', 'required' => [ 'browserIdentifier', 'sessionId', 'createdAt', ], 'members' => [ 'browserIdentifier' => [ 'shape' => 'String', ], 'sessionId' => [ 'shape' => 'BrowserSessionId', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], 'streams' => [ 'shape' => 'BrowserSessionStream', ], ], ], 'StartCodeInterpreterSessionRequest' => [ 'type' => 'structure', 'required' => [ 'codeInterpreterIdentifier', ], 'members' => [ 'codeInterpreterIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'codeInterpreterIdentifier', ], 'name' => [ 'shape' => 'Name', ], 'sessionTimeoutSeconds' => [ 'shape' => 'CodeInterpreterSessionTimeout', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'StartCodeInterpreterSessionResponse' => [ 'type' => 'structure', 'required' => [ 'codeInterpreterIdentifier', 'sessionId', 'createdAt', ], 'members' => [ 'codeInterpreterIdentifier' => [ 'shape' => 'String', ], 'sessionId' => [ 'shape' => 'CodeInterpreterSessionId', ], 'createdAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'StopBrowserSessionRequest' => [ 'type' => 'structure', 'required' => [ 'browserIdentifier', 'sessionId', ], 'members' => [ 'browserIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'browserIdentifier', ], 'sessionId' => [ 'shape' => 'BrowserSessionId', 'location' => 'querystring', 'locationName' => 'sessionId', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'StopBrowserSessionResponse' => [ 'type' => 'structure', 'required' => [ 'browserIdentifier', 'sessionId', 'lastUpdatedAt', ], 'members' => [ 'browserIdentifier' => [ 'shape' => 'String', ], 'sessionId' => [ 'shape' => 'BrowserSessionId', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'StopCodeInterpreterSessionRequest' => [ 'type' => 'structure', 'required' => [ 'codeInterpreterIdentifier', 'sessionId', ], 'members' => [ 'codeInterpreterIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'codeInterpreterIdentifier', ], 'sessionId' => [ 'shape' => 'CodeInterpreterSessionId', 'location' => 'querystring', 'locationName' => 'sessionId', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'StopCodeInterpreterSessionResponse' => [ 'type' => 'structure', 'required' => [ 'codeInterpreterIdentifier', 'sessionId', 'lastUpdatedAt', ], 'members' => [ 'codeInterpreterIdentifier' => [ 'shape' => 'String', ], 'sessionId' => [ 'shape' => 'CodeInterpreterSessionId', ], 'lastUpdatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'StreamUpdate' => [ 'type' => 'structure', 'members' => [ 'automationStreamUpdate' => [ 'shape' => 'AutomationStreamUpdate', ], ], 'union' => true, ], 'String' => [ 'type' => 'string', ], 'StringList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MaxLenString', ], ], 'StringType' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'TaskStatus' => [ 'type' => 'string', 'enum' => [ 'submitted', 'working', 'completed', 'canceled', 'failed', ], ], 'ThrottledException' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], 'ThrottlingException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], 'Timestamp' => [ 'type' => 'timestamp', ], 'ToolArguments' => [ 'type' => 'structure', 'members' => [ 'code' => [ 'shape' => 'MaxLenString', ], 'language' => [ 'shape' => 'ProgrammingLanguage', ], 'clearContext' => [ 'shape' => 'Boolean', ], 'command' => [ 'shape' => 'MaxLenString', ], 'path' => [ 'shape' => 'MaxLenString', ], 'paths' => [ 'shape' => 'StringList', ], 'content' => [ 'shape' => 'InputContentBlockList', ], 'directoryPath' => [ 'shape' => 'MaxLenString', ], 'taskId' => [ 'shape' => 'MaxLenString', ], ], ], 'ToolName' => [ 'type' => 'string', 'enum' => [ 'executeCode', 'executeCommand', 'readFiles', 'listFiles', 'removeFiles', 'writeFiles', 'startCommandExecution', 'getTask', 'stopTask', ], ], 'ToolResultStructuredContent' => [ 'type' => 'structure', 'members' => [ 'taskId' => [ 'shape' => 'String', ], 'taskStatus' => [ 'shape' => 'TaskStatus', ], 'stdout' => [ 'shape' => 'String', ], 'stderr' => [ 'shape' => 'String', ], 'exitCode' => [ 'shape' => 'Integer', ], 'executionTime' => [ 'shape' => 'Double', ], ], ], 'UnauthorizedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 401, 'senderFault' => true, ], 'exception' => true, ], 'UpdateBrowserStreamRequest' => [ 'type' => 'structure', 'required' => [ 'browserIdentifier', 'sessionId', 'streamUpdate', ], 'members' => [ 'browserIdentifier' => [ 'shape' => 'String', 'location' => 'uri', 'locationName' => 'browserIdentifier', ], 'sessionId' => [ 'shape' => 'BrowserSessionId', 'location' => 'querystring', 'locationName' => 'sessionId', ], 'streamUpdate' => [ 'shape' => 'StreamUpdate', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'UpdateBrowserStreamResponse' => [ 'type' => 'structure', 'required' => [ 'browserIdentifier', 'sessionId', 'streams', 'updatedAt', ], 'members' => [ 'browserIdentifier' => [ 'shape' => 'String', ], 'sessionId' => [ 'shape' => 'BrowserSessionId', ], 'streams' => [ 'shape' => 'BrowserSessionStream', ], 'updatedAt' => [ 'shape' => 'DateTimestamp', ], ], ], 'UserIdType' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'UserTokenType' => [ 'type' => 'string', 'max' => 131072, 'min' => 1, 'pattern' => '[A-Za-z0-9-_=]+.[A-Za-z0-9-_=]+.[A-Za-z0-9-_=]+', 'sensitive' => true, ], 'ValidationException' => [ 'type' => 'structure', 'required' => [ 'message', 'reason', ], 'members' => [ 'message' => [ 'shape' => 'String', ], 'reason' => [ 'shape' => 'ValidationExceptionReason', ], 'fieldList' => [ 'shape' => 'ValidationExceptionFieldList', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'ValidationExceptionField' => [ 'type' => 'structure', 'required' => [ 'name', 'message', ], 'members' => [ 'name' => [ 'shape' => 'String', ], 'message' => [ 'shape' => 'String', ], ], ], 'ValidationExceptionFieldList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ValidationExceptionField', ], ], 'ValidationExceptionReason' => [ 'type' => 'string', 'enum' => [ 'CannotParse', 'FieldValidationFailed', 'IdempotentParameterMismatchException', 'EventInOtherSession', 'ResourceConflict', ], ], 'ViewPort' => [ 'type' => 'structure', 'required' => [ 'width', 'height', ], 'members' => [ 'width' => [ 'shape' => 'ViewPortWidth', ], 'height' => [ 'shape' => 'ViewPortHeight', ], ], ], 'ViewPortHeight' => [ 'type' => 'integer', 'box' => true, 'max' => 2160, 'min' => 240, ], 'ViewPortWidth' => [ 'type' => 'integer', 'box' => true, 'max' => 3840, 'min' => 320, ], 'WorkloadIdentityNameType' => [ 'type' => 'string', 'max' => 255, 'min' => 3, 'pattern' => '[A-Za-z0-9_.-]+', ], 'WorkloadIdentityTokenType' => [ 'type' => 'string', 'max' => 131072, 'min' => 1, 'sensitive' => true, ], ],];
