<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class CustomPurchaseVerificationController extends Controller
{
    /**
     * Bypass purchase verification - redirect to login
     */
    public function verifyPurchase()
    {
        // Bypass license verification - redirect to login
        return redirect()->route('login');
    }

    /**
     * Bypass purchase verification - return success
     */
    public function purchaseVerified(Request $request)
    {
        // Bypass license verification - return success and redirect to login
        return redirect()->route('login')->with('success', 'License verified successfully');
    }
}
